# Proyecto 3.1. Preparando el fútbol de robots

En esta actividad vas a completar un programa para que el robot Beto juegue al fútbol, 
llevando una pelota hacia el arco y haciendo un gol. 
Pero en lugar de darte al Beto, la pelota y el arco ya hechos, vamos a pedirte que los 
representes con bolitas, justo como en la actividad anterior.
La representación se hace como indica la siguiente tabla:

| Elemento a representar | Representación | 
|:-----------------------|:---------------|
| El robot Beto          | 1 bolita azul  | 
| La pelota              | 1 bolita negra |
| El arco                | 1 bolita roja  |

El tablero inicial es el siguiente:

<center>
![Tablero inicial sin vestimenta](data:image/png;base64,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)
</center>

¡Pero no se ve un robot o una pelota, sino bolitas! 
Para eso podés usar las vestimentas: cliqueá en el ojo…
¡Ahora sí tenemos al robot Beto, una pelota y un arco! 

Para poder hacer el programa vamos a precisar algunos procedimientos que, en lugar de hablar de 
poner y sacar bolitas, hablen de poner, sacar y mover al Beto y a la pelota, y de mover la pierna del robot. 
Es como en la actividad _“Armamos 'El alien toca botón'”_, pero con un poco más de complejidad.
Vamos por partes:
* en esta actividad el Beto se mueve de a un lugar hacia el Este, para lo cual hay que sacar las bolitas de 
  una celda y ponerlas en otra;
* la pelota se mueve de a dos celdas por vez que es pateada, también hacia el Este, pero, para patear la 
  pelota, el Beto debe llegar a ella y mover el pie;
* para mover el pie, se pone y se saca una bolita azul sobre el robot; es decir, dos bolitas azules 
  representan al Beto con el pie preparado para patear.

Tu tarea es completar el programa que permita que el Beto patee la pelota hasta meter el gol. 
Para eso tenés que terminar de definir los procedimientos que te damos, y utilizarlos para que el 
programa cumpla su cometido.

> **El dato**
>
> Al activar la vestimenta cambia el aspecto del tablero y se ve como si las celdas fueran otra cosa…
> ¿Te acordás de la actividad de los caramelos y los tomates? 
> En algunas actividades vos podés elegir activar o desactivar la vestimenta. Y cuando hagas tus propios
> programas, vas a poder elegir qué vestimenta.

[Enunciado en PDF][PDF]

[PDF]: https://raw.githubusercontent.com/gobstones/curso-InPr-UNQ/master/Proyectos/2.Procedimientos/3.1.Preparando%20el%20f%C3%BAtbol%20de%20robots/assets/resources/description.pdf "Enunciado de 'Preparando el fútbol de robots' en PDF"
